package tonematrix.gui;
import tonematrix.*;
import javax.swing.*;
import java.io.*;
import java.util.*;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.*;
import java.lang.reflect.*;

/* Program that lets the user select scenes and watch the result. */
public class ToneMatrixGUI {
    private JFrame window;
    private ToneMatrixDisplay display;
    
    private static final int DEFAULT_GRID_SIZE  = 16;
    private static final int DEFAULT_LIGHT_SIZE = 50;
    
    public ToneMatrixGUI(int gridSize, int lightSize) {
        /* Main window. */
        window = new JFrame();
        window.setLayout(new BorderLayout());
        window.setTitle("Tone Matrix");
        window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        /* Main display. */   
        display = new ToneMatrixDisplay(gridSize, lightSize);     
        window.add(display, BorderLayout.CENTER);
        
        /* Show the world our result. */
        window.pack();
        window.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception e) {
            System.err.println("Cannot set look and feel; falling back on default.");
        }
        
        int gridSize = DEFAULT_GRID_SIZE;
        if (args.length >= 1) gridSize = Integer.parseInt(args[0]);
        
        int lightSize = DEFAULT_LIGHT_SIZE;
        if (args.length >= 2) lightSize = Integer.parseInt(args[0]);
        
        new ToneMatrixGUI(gridSize, lightSize);
    }
}
