package tonematrix;
import java.awt.Color;

/* Interface representing something that can draw rectangles on the screen. */
public interface ToneMatrixGraphics {
    /**
     * Draws a rectangle of the given dimensions at the indicated spot on the screen,
     * using the specified color.
     *
     * @param x The x coordinate of the upper-left corner of the rectangle.
     * @param y The y coordinate of the upper-left corner of the rectangle.
     * @param width The width of the rectangle, in pixels.
     * @param height The height of the rectangle, in pixels.
     * @param color The color of the rectangle.
     */
    public void drawRectangle(int x, int y, int width, int height, Color color);
}
