package tonematrix;
import java.awt.Color;

/* Type that maintains a Tone Matrix, reacts to mouse movement,
 * handles graphics, and sends data to the computer speakers.
 */
public class ToneMatrix {
    /* Color of a light that is off and that is on. */
    public static final Color LIGHT_OFF_COLOR = new Color( 64,  64,  64);
    public static final Color LIGHT_ON_COLOR  = new Color(192, 192, 192);

    /**
     * Given a row index, returns the frequency of the note played by the
     * instrument at that index.
     * <p>
     * For those of you who are musically inclined: the base frequency is
     * chosen to be a low C. The remaining notes are then repeated major
     * pentatonic scales stacked on top. To see why, note that one half step
     * corresponds to multiplying the frequency by the twelfth root of two.
     * Therefore, multiplying a frequency by pow(2, n / 12.0) corresponds
     * to taking the note n half-steps above the base frequency.
     * <p>
     * Feel free to tinker and tweak these frequencies as an extension.
     * However, don't modify them when working on the base assignment;
     * our test cases make some assumptions based on how they work.
     *
     * @param rowIndex The row in the Tone Matrix in question.
     * @return The frequency, in Hz, of the instrument for that row.
     */
    static double frequencyForRow(int rowIndex) {
        if (rowIndex < 0) throw new RuntimeException("Invalid row index: " + rowIndex);

        /* Pentatonic note offsets from the base note, in number of
         * half steps. Each row lowers the frequency, so we count
         * down by the number of half steps.
         */
        int[] kPentatonicSteps = new int[]{
            0, -3, -5, -8, -10
        };

        /* High C. */
        final double kBaseFrequency = 220 * Math.pow(2, (30.0 + 9.0) / 12.0);

        /* Convert offset to how many octaves down to shift. */
        int octave = rowIndex / 5;

        /* Determine how many half steps we need to shift down. */
        int halfSteps = (-(12 * octave) + kPentatonicSteps[rowIndex % 5]);

        /* Each half step corresponds to scaling the frequency by the twelfth root of
         * two. Therefore, taking a bunch of half steps down is equivalent to
         * multiplying by some power of the twelfth root of two.
         */
        return kBaseFrequency * Math.pow(2.0, halfSteps / 12.0);
    }

    /**
     * The number of samples that make up one note. After this many calls
     * to nextSample(), the Tone Matrix moves on from its current note to
     * the next note.
     */
    public static final int NOTE_LENGTH = 8192;

    /**
     * Creates a Tone Matrix whose grid is gridDimension x gridDimension
     * and where each light in the matrix has size lightDimension x lightDimension.
     * The lightDimension parameter just determines the size, in pixels,
     * of each light in the grid.
     *
     * @param gridDimension The number of lights in each row and column of the grid.
     * @param lightDimension The number of pixels per side of each light.
     */
    public ToneMatrix(int gridDimension, int lightDimension) {
        // TODO: Delete this comment and implement this method.
    }

    /**
     * Reacts to the mouse being pressed at a given location.
     * Specifically, this toggles the state of the light under the
     * mouse.
     *
     * @param mouseX The x coordinate of the mouse.
     * @param mouseY The y coordinate of the mouse.
     */
    public void mousePressed(int mouseX, int mouseY) {
        // TODO: Delete this comment and implement this method.
    }

    /**
     * Reacts to the mouse being dragged at a given location (moved
     * while pressed). Specifically, this updates the light under the
     * mouse to match the state of the light where the mouse was
     * first pressed.
     *
     * @param mouseX The x coordinate of the mouse.
     * @param mouseY The y coordinate of the mouse.
     */
    public void mouseDragged(int mouseX, int mouseY) {
        // TODO: Delete this comment and implement this method.
    }

    /**
     * Draws the Tone Matrix to the screen.
     *
     * @param graphics The graphics object to use to do the rendering.
     */
    public void draw(ToneMatrixGraphics graphics) {
        // TODO: Delete this comment and implement this method.
    }

    /**
     * Produces the next sound sample from the Tone Matrix.
     *
     * @return The next sound sample produced by the Tone Matrix.
     */
    public double nextSample() {
        // TODO: Delete this comment and implement this method.
        return 0;
    }

    /**
     * Resizes the underlying grid of lights. New lights default
     * to being turned off; old lights retain their previous
     * values. Old instruments are preserved. The left-to-right
     * scan of the grid resets back to the leftmost column, as if
     * the Tone Matrix was being created anew.
     *
     * @param newGridSize The new dimensions of the Tone Matrix.
     */
    public void resize(int newGridSize) {
        // TODO: Delete this comment and implement this method.
    }

    int                lightSize;    // Size of each light, in pixels.
    boolean[]          grid;         // The lights in the grid
    StringInstrument[] instruments;  // Instrument associated with each row
}
