package tonematrix;

import princeton.StdAudio;

/* Type representing the audio system. This type is used in three
 * separate ways. First, the StringInstrument type uses it to
 * determine the sampling rate, which is in turn used to determine
 * the sizes of the internal arrays. Second, our test cases use
 * the setSampleRate function to make it easier to test the
 * StringInstrument's array-building code. Finally, the final
 * application uses play() to send audio to the speakers.
 */
public class AudioSystem {
    private static int theSampleRate = 44100;

    /* Can't be instantiated. */
    private AudioSystem() {

    }
    
    /**
     * Returns the current sample rate.
     *
     * @return The current sample rate.
     */
    public static int sampleRate() {
        return theSampleRate;
    }
    
    /**
     * Sets the sample rate. 
     *
     * @param newRate The new sample rate.
     */
    public static void setSampleRate(int newRate) {
        theSampleRate = newRate;
    }
    
    /**
     * Sends the given sound sample to the speakers.
     *
     * @param amplitude The soudn sample to send to the speakers,
     *        which should be between -1 and +1.
     */
    public static void play(double amplitude) {
        StdAudio.play(amplitude);
    }
}
